package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  DatastoreArn,
  DatastoreName
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Datastore(
    name: Optional[DatastoreName] = Optional.Absent,
    storage: Optional[zio.aws.iotanalytics.model.DatastoreStorage] =
      Optional.Absent,
    arn: Optional[DatastoreArn] = Optional.Absent,
    status: Optional[zio.aws.iotanalytics.model.DatastoreStatus] =
      Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent,
    lastMessageArrivalTime: Optional[Timestamp] = Optional.Absent,
    fileFormatConfiguration: Optional[
      zio.aws.iotanalytics.model.FileFormatConfiguration
    ] = Optional.Absent,
    datastorePartitions: Optional[
      zio.aws.iotanalytics.model.DatastorePartitions
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Datastore = {
    import Datastore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Datastore
      .builder()
      .optionallyWith(
        name.map(value => DatastoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .optionallyWith(
        arn.map(value => DatastoreArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .optionallyWith(
        fileFormatConfiguration.map(value => value.buildAwsValue())
      )(_.fileFormatConfiguration)
      .optionallyWith(datastorePartitions.map(value => value.buildAwsValue()))(
        _.datastorePartitions
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Datastore.ReadOnly =
    zio.aws.iotanalytics.model.Datastore.wrap(buildAwsValue())
}
object Datastore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Datastore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Datastore =
      zio.aws.iotanalytics.model.Datastore(
        name.map(value => value),
        storage.map(value => value.asEditable),
        arn.map(value => value),
        status.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value),
        fileFormatConfiguration.map(value => value.asEditable),
        datastorePartitions.map(value => value.asEditable)
      )
    def name: Optional[DatastoreName]
    def storage: Optional[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly]
    def arn: Optional[DatastoreArn]
    def status: Optional[zio.aws.iotanalytics.model.DatastoreStatus]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def creationTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def lastMessageArrivalTime: Optional[Timestamp]
    def fileFormatConfiguration
        : Optional[zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly]
    def datastorePartitions
        : Optional[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly]
    def getName: ZIO[Any, AwsError, DatastoreName] =
      AwsError.unwrapOptionField("name", name)
    def getStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly
    ] = AwsError.unwrapOptionField("storage", storage)
    def getArn: ZIO[Any, AwsError, DatastoreArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatastoreStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
    def getFileFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fileFormatConfiguration",
      fileFormatConfiguration
    )
    def getDatastorePartitions: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly
    ] = AwsError.unwrapOptionField("datastorePartitions", datastorePartitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Datastore
  ) extends zio.aws.iotanalytics.model.Datastore.ReadOnly {
    override val name: Optional[DatastoreName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreName(value))
    override val storage
        : Optional[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storage())
        .map(value => zio.aws.iotanalytics.model.DatastoreStorage.wrap(value))
    override val arn: Optional[DatastoreArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreArn(value))
    override val status: Optional[zio.aws.iotanalytics.model.DatastoreStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iotanalytics.model.DatastoreStatus.wrap(value))
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastMessageArrivalTime())
        .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val fileFormatConfiguration: Optional[
      zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileFormatConfiguration())
      .map(value =>
        zio.aws.iotanalytics.model.FileFormatConfiguration.wrap(value)
      )
    override val datastorePartitions
        : Optional[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.datastorePartitions())
        .map(value =>
          zio.aws.iotanalytics.model.DatastorePartitions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Datastore
  ): zio.aws.iotanalytics.model.Datastore.ReadOnly = new Wrapper(impl)
}
