package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutLoggingOptionsRequest(
    loggingOptions: zio.aws.iotanalytics.model.LoggingOptions
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest = {
    import PutLoggingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest
      .builder()
      .loggingOptions(loggingOptions.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.PutLoggingOptionsRequest.ReadOnly =
    zio.aws.iotanalytics.model.PutLoggingOptionsRequest.wrap(buildAwsValue())
}
object PutLoggingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.PutLoggingOptionsRequest =
      zio.aws.iotanalytics.model
        .PutLoggingOptionsRequest(loggingOptions.asEditable)
    def loggingOptions: zio.aws.iotanalytics.model.LoggingOptions.ReadOnly
    def getLoggingOptions: ZIO[
      Any,
      Nothing,
      zio.aws.iotanalytics.model.LoggingOptions.ReadOnly
    ] = ZIO.succeed(loggingOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest
  ) extends zio.aws.iotanalytics.model.PutLoggingOptionsRequest.ReadOnly {
    override val loggingOptions
        : zio.aws.iotanalytics.model.LoggingOptions.ReadOnly =
      zio.aws.iotanalytics.model.LoggingOptions.wrap(impl.loggingOptions())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.PutLoggingOptionsRequest
  ): zio.aws.iotanalytics.model.PutLoggingOptionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
