package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatastoreIotSiteWiseMultiLayerStorageSummary(
    customerManagedS3Storage: Optional[
      zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary = {
    import DatastoreIotSiteWiseMultiLayerStorageSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
      .builder()
      .optionallyWith(
        customerManagedS3Storage.map(value => value.buildAwsValue())
      )(_.customerManagedS3Storage)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
      .wrap(buildAwsValue())
}
object DatastoreIotSiteWiseMultiLayerStorageSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary =
      zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary(
        customerManagedS3Storage.map(value => value.asEditable)
      )
    def customerManagedS3Storage: Optional[
      zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary.ReadOnly
    ]
    def getCustomerManagedS3Storage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customerManagedS3Storage",
      customerManagedS3Storage
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
  ) extends zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary.ReadOnly {
    override val customerManagedS3Storage: Optional[
      zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customerManagedS3Storage())
      .map(value =>
        zio.aws.iotanalytics.model.IotSiteWiseCustomerManagedDatastoreS3StorageSummary
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary
  ): zio.aws.iotanalytics.model.DatastoreIotSiteWiseMultiLayerStorageSummary.ReadOnly =
    new Wrapper(impl)
}
