package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.S3PathChannelMessage
import scala.jdk.CollectionConverters._
final case class ChannelMessages(
    s3Paths: Optional[Iterable[S3PathChannelMessage]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ChannelMessages = {
    import ChannelMessages.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ChannelMessages
      .builder()
      .optionallyWith(
        s3Paths.map(value =>
          value.map { item =>
            S3PathChannelMessage.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.s3Paths)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ChannelMessages.ReadOnly =
    zio.aws.iotanalytics.model.ChannelMessages.wrap(buildAwsValue())
}
object ChannelMessages {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ChannelMessages
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ChannelMessages =
      zio.aws.iotanalytics.model.ChannelMessages(s3Paths.map(value => value))
    def s3Paths: Optional[List[S3PathChannelMessage]]
    def getS3Paths: ZIO[Any, AwsError, List[S3PathChannelMessage]] =
      AwsError.unwrapOptionField("s3Paths", s3Paths)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelMessages
  ) extends zio.aws.iotanalytics.model.ChannelMessages.ReadOnly {
    override val s3Paths: Optional[List[S3PathChannelMessage]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Paths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.primitives.S3PathChannelMessage(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelMessages
  ): zio.aws.iotanalytics.model.ChannelMessages.ReadOnly = new Wrapper(impl)
}
