package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeChannelResponse(
    channel: Optional[zio.aws.iotanalytics.model.Channel] = Optional.Absent,
    statistics: Optional[zio.aws.iotanalytics.model.ChannelStatistics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse = {
    import DescribeChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(statistics.map(value => value.buildAwsValue()))(
        _.statistics
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly =
    zio.aws.iotanalytics.model.DescribeChannelResponse.wrap(buildAwsValue())
}
object DescribeChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeChannelResponse =
      zio.aws.iotanalytics.model.DescribeChannelResponse(
        channel.map(value => value.asEditable),
        statistics.map(value => value.asEditable)
      )
    def channel: Optional[zio.aws.iotanalytics.model.Channel.ReadOnly]
    def statistics
        : Optional[zio.aws.iotanalytics.model.ChannelStatistics.ReadOnly]
    def getChannel
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
    def getStatistics: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStatistics.ReadOnly
    ] = AwsError.unwrapOptionField("statistics", statistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
  ) extends zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly {
    override val channel
        : Optional[zio.aws.iotanalytics.model.Channel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.iotanalytics.model.Channel.wrap(value))
    override val statistics
        : Optional[zio.aws.iotanalytics.model.ChannelStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statistics())
        .map(value => zio.aws.iotanalytics.model.ChannelStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeChannelResponse
  ): zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
