package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{GlueDatabaseName, GlueTableName}
import scala.jdk.CollectionConverters._
final case class GlueConfiguration(
    tableName: GlueTableName,
    databaseName: GlueDatabaseName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.GlueConfiguration = {
    import GlueConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.GlueConfiguration
      .builder()
      .tableName(GlueTableName.unwrap(tableName): java.lang.String)
      .databaseName(GlueDatabaseName.unwrap(databaseName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.GlueConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.GlueConfiguration.wrap(buildAwsValue())
}
object GlueConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.GlueConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.GlueConfiguration =
      zio.aws.iotanalytics.model.GlueConfiguration(tableName, databaseName)
    def tableName: GlueTableName
    def databaseName: GlueDatabaseName
    def getTableName: ZIO[Any, Nothing, GlueTableName] = ZIO.succeed(tableName)
    def getDatabaseName: ZIO[Any, Nothing, GlueDatabaseName] =
      ZIO.succeed(databaseName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.GlueConfiguration
  ) extends zio.aws.iotanalytics.model.GlueConfiguration.ReadOnly {
    override val tableName: GlueTableName =
      zio.aws.iotanalytics.model.primitives.GlueTableName(impl.tableName())
    override val databaseName: GlueDatabaseName =
      zio.aws.iotanalytics.model.primitives
        .GlueDatabaseName(impl.databaseName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.GlueConfiguration
  ): zio.aws.iotanalytics.model.GlueConfiguration.ReadOnly = new Wrapper(impl)
}
