package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.EntryName
import scala.jdk.CollectionConverters._
final case class DatasetContentDeliveryRule(
    entryName: Optional[EntryName] = Optional.Absent,
    destination: zio.aws.iotanalytics.model.DatasetContentDeliveryDestination
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule = {
    import DatasetContentDeliveryRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule
      .builder()
      .optionallyWith(
        entryName.map(value => EntryName.unwrap(value): java.lang.String)
      )(_.entryName)
      .destination(destination.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly =
    zio.aws.iotanalytics.model.DatasetContentDeliveryRule.wrap(buildAwsValue())
}
object DatasetContentDeliveryRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetContentDeliveryRule =
      zio.aws.iotanalytics.model.DatasetContentDeliveryRule(
        entryName.map(value => value),
        destination.asEditable
      )
    def entryName: Optional[EntryName]
    def destination
        : zio.aws.iotanalytics.model.DatasetContentDeliveryDestination.ReadOnly
    def getEntryName: ZIO[Any, AwsError, EntryName] =
      AwsError.unwrapOptionField("entryName", entryName)
    def getDestination: ZIO[
      Any,
      Nothing,
      zio.aws.iotanalytics.model.DatasetContentDeliveryDestination.ReadOnly
    ] = ZIO.succeed(destination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule
  ) extends zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly {
    override val entryName: Optional[EntryName] = zio.aws.core.internal
      .optionalFromNullable(impl.entryName())
      .map(value => zio.aws.iotanalytics.model.primitives.EntryName(value))
    override val destination
        : zio.aws.iotanalytics.model.DatasetContentDeliveryDestination.ReadOnly =
      zio.aws.iotanalytics.model.DatasetContentDeliveryDestination
        .wrap(impl.destination())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentDeliveryRule
  ): zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly =
    new Wrapper(impl)
}
