package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class GetDatasetContentResponse(
    entries: Optional[Iterable[zio.aws.iotanalytics.model.DatasetEntry]] =
      Optional.Absent,
    timestamp: Optional[Timestamp] = Optional.Absent,
    status: Optional[zio.aws.iotanalytics.model.DatasetContentStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse = {
    import GetDatasetContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
      .builder()
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly =
    zio.aws.iotanalytics.model.GetDatasetContentResponse.wrap(buildAwsValue())
}
object GetDatasetContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.GetDatasetContentResponse =
      zio.aws.iotanalytics.model.GetDatasetContentResponse(
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timestamp.map(value => value),
        status.map(value => value.asEditable)
      )
    def entries
        : Optional[List[zio.aws.iotanalytics.model.DatasetEntry.ReadOnly]]
    def timestamp: Optional[Timestamp]
    def status
        : Optional[zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly]
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
  ) extends zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly {
    override val entries
        : Optional[List[zio.aws.iotanalytics.model.DatasetEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.entries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetEntry.wrap(item)
          }.toList
        )
    override val timestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.timestamp())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val status
        : Optional[zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.iotanalytics.model.DatasetContentStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
  ): zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly =
    new Wrapper(impl)
}
