package zio.aws.iotanalytics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{TimeExpression, OffsetSeconds}
import scala.jdk.CollectionConverters._
final case class DeltaTime(
    offsetSeconds: OffsetSeconds,
    timeExpression: TimeExpression
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DeltaTime = {
    import DeltaTime.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DeltaTime
      .builder()
      .offsetSeconds(OffsetSeconds.unwrap(offsetSeconds): Integer)
      .timeExpression(TimeExpression.unwrap(timeExpression): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DeltaTime.ReadOnly =
    zio.aws.iotanalytics.model.DeltaTime.wrap(buildAwsValue())
}
object DeltaTime {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DeltaTime
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DeltaTime =
      zio.aws.iotanalytics.model.DeltaTime(offsetSeconds, timeExpression)
    def offsetSeconds: OffsetSeconds
    def timeExpression: TimeExpression
    def getOffsetSeconds: ZIO[Any, Nothing, OffsetSeconds] =
      ZIO.succeed(offsetSeconds)
    def getTimeExpression: ZIO[Any, Nothing, TimeExpression] =
      ZIO.succeed(timeExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeltaTime
  ) extends zio.aws.iotanalytics.model.DeltaTime.ReadOnly {
    override val offsetSeconds: OffsetSeconds =
      zio.aws.iotanalytics.model.primitives.OffsetSeconds(impl.offsetSeconds())
    override val timeExpression: TimeExpression =
      zio.aws.iotanalytics.model.primitives
        .TimeExpression(impl.timeExpression())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DeltaTime
  ): zio.aws.iotanalytics.model.DeltaTime.ReadOnly = new Wrapper(impl)
}
