package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DatastorePartition(
    attributePartition: Optional[zio.aws.iotanalytics.model.Partition] =
      Optional.Absent,
    timestampPartition: Optional[
      zio.aws.iotanalytics.model.TimestampPartition
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastorePartition = {
    import DatastorePartition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastorePartition
      .builder()
      .optionallyWith(attributePartition.map(value => value.buildAwsValue()))(
        _.attributePartition
      )
      .optionallyWith(timestampPartition.map(value => value.buildAwsValue()))(
        _.timestampPartition
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastorePartition.ReadOnly =
    zio.aws.iotanalytics.model.DatastorePartition.wrap(buildAwsValue())
}
object DatastorePartition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastorePartition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastorePartition =
      zio.aws.iotanalytics.model.DatastorePartition(
        attributePartition.map(value => value.asEditable),
        timestampPartition.map(value => value.asEditable)
      )
    def attributePartition
        : Optional[zio.aws.iotanalytics.model.Partition.ReadOnly]
    def timestampPartition
        : Optional[zio.aws.iotanalytics.model.TimestampPartition.ReadOnly]
    def getAttributePartition
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Partition.ReadOnly] =
      AwsError.unwrapOptionField("attributePartition", attributePartition)
    def getTimestampPartition: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.TimestampPartition.ReadOnly
    ] = AwsError.unwrapOptionField("timestampPartition", timestampPartition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastorePartition
  ) extends zio.aws.iotanalytics.model.DatastorePartition.ReadOnly {
    override val attributePartition
        : Optional[zio.aws.iotanalytics.model.Partition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributePartition())
        .map(value => zio.aws.iotanalytics.model.Partition.wrap(value))
    override val timestampPartition
        : Optional[zio.aws.iotanalytics.model.TimestampPartition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestampPartition())
        .map(value => zio.aws.iotanalytics.model.TimestampPartition.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastorePartition
  ): zio.aws.iotanalytics.model.DatastorePartition.ReadOnly = new Wrapper(impl)
}
