package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{ChannelArn, ChannelName}
import scala.jdk.CollectionConverters._
final case class CreateChannelResponse(
    channelName: Optional[ChannelName] = Optional.Absent,
    channelArn: Optional[ChannelArn] = Optional.Absent,
    retentionPeriod: Optional[zio.aws.iotanalytics.model.RetentionPeriod] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse = {
    import CreateChannelResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse
      .builder()
      .optionallyWith(
        channelName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.channelName)
      .optionallyWith(
        channelArn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly =
    zio.aws.iotanalytics.model.CreateChannelResponse.wrap(buildAwsValue())
}
object CreateChannelResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateChannelResponse =
      zio.aws.iotanalytics.model.CreateChannelResponse(
        channelName.map(value => value),
        channelArn.map(value => value),
        retentionPeriod.map(value => value.asEditable)
      )
    def channelName: Optional[ChannelName]
    def channelArn: Optional[ChannelArn]
    def retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def getChannelName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("channelName", channelName)
    def getChannelArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse
  ) extends zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly {
    override val channelName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.channelName())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelName(value))
    override val channelArn: Optional[ChannelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelArn(value))
    override val retentionPeriod
        : Optional[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retentionPeriod())
        .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateChannelResponse
  ): zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly = new Wrapper(
    impl
  )
}
