package zio.aws.iotanalytics
import zio.mock.{Proxy, Mock}
import zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly
import zio.aws.iotanalytics.model.{
  BatchPutMessageRequest,
  DescribeLoggingOptionsRequest,
  CreateDatasetRequest,
  DescribeDatastoreRequest,
  DeleteDatasetContentRequest,
  DeleteChannelRequest,
  CreateChannelRequest,
  DescribeDatasetRequest,
  SampleChannelDataRequest,
  ListTagsForResourceRequest,
  ListPipelinesRequest,
  DescribePipelineRequest,
  ListDatasetsRequest,
  RunPipelineActivityRequest,
  ListDatastoresRequest,
  ListDatasetContentsRequest,
  UpdateChannelRequest,
  StartPipelineReprocessingRequest,
  UpdateDatastoreRequest,
  DeletePipelineRequest,
  DeleteDatasetRequest,
  CreateDatastoreRequest,
  PutLoggingOptionsRequest,
  ListChannelsRequest,
  UntagResourceRequest,
  GetDatasetContentRequest,
  CreatePipelineRequest,
  CreateDatasetContentRequest,
  UpdateDatasetRequest,
  UpdatePipelineRequest,
  DescribeChannelRequest,
  DeleteDatastoreRequest,
  CancelPipelineReprocessingRequest,
  TagResourceRequest
}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import software.amazon.awssdk.services.iotanalytics.IoTAnalyticsAsyncClient
object IoTAnalyticsMock extends Mock[IoTAnalytics] {
  object CreateDataset
      extends Effect[
        CreateDatasetRequest,
        AwsError,
        zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly
      ]
  object ListChannels
      extends Effect[
        ListChannelsRequest,
        AwsError,
        zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly
      ]
  object CreateDatastore
      extends Effect[
        CreateDatastoreRequest,
        AwsError,
        zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly
      ]
  object ListDatastores
      extends Effect[
        ListDatastoresRequest,
        AwsError,
        zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly
      ]
  object DeleteDatastore extends Effect[DeleteDatastoreRequest, AwsError, Unit]
  object DescribeLoggingOptions
      extends Effect[
        DescribeLoggingOptionsRequest,
        AwsError,
        zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly
      ]
  object UpdatePipeline extends Effect[UpdatePipelineRequest, AwsError, Unit]
  object RunPipelineActivity
      extends Effect[
        RunPipelineActivityRequest,
        AwsError,
        zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly
      ]
  object UpdateDatastore extends Effect[UpdateDatastoreRequest, AwsError, Unit]
  object DeleteChannel extends Effect[DeleteChannelRequest, AwsError, Unit]
  object DescribeDataset
      extends Effect[
        DescribeDatasetRequest,
        AwsError,
        zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly
      ]
  object DescribePipeline
      extends Effect[
        DescribePipelineRequest,
        AwsError,
        zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly
      ]
  object ListPipelines
      extends Effect[
        ListPipelinesRequest,
        AwsError,
        zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly
      ]
  object PutLoggingOptions
      extends Effect[PutLoggingOptionsRequest, AwsError, Unit]
  object DescribeDatastore
      extends Effect[
        DescribeDatastoreRequest,
        AwsError,
        zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly
      ]
  object UpdateDataset extends Effect[UpdateDatasetRequest, AwsError, Unit]
  object CreateChannel
      extends Effect[
        CreateChannelRequest,
        AwsError,
        zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly
      ]
  object StartPipelineReprocessing
      extends Effect[
        StartPipelineReprocessingRequest,
        AwsError,
        zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly
      ]
  object BatchPutMessage
      extends Effect[
        BatchPutMessageRequest,
        AwsError,
        zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.iotanalytics.model.UntagResourceResponse.ReadOnly
      ]
  object ListDatasetContents
      extends Effect[
        ListDatasetContentsRequest,
        AwsError,
        zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly
      ]
  object ListDatasets
      extends Effect[
        ListDatasetsRequest,
        AwsError,
        zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly
      ]
  object DeletePipeline extends Effect[DeletePipelineRequest, AwsError, Unit]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.iotanalytics.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.iotanalytics.model.TagResourceResponse.ReadOnly
      ]
  object DescribeChannel
      extends Effect[
        DescribeChannelRequest,
        AwsError,
        zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly
      ]
  object GetDatasetContent
      extends Effect[GetDatasetContentRequest, AwsError, ReadOnly]
  object SampleChannelData
      extends Effect[
        SampleChannelDataRequest,
        AwsError,
        zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly
      ]
  object DeleteDataset extends Effect[DeleteDatasetRequest, AwsError, Unit]
  object DeleteDatasetContent
      extends Effect[DeleteDatasetContentRequest, AwsError, Unit]
  object CreatePipeline
      extends Effect[
        CreatePipelineRequest,
        AwsError,
        zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly
      ]
  object CreateDatasetContent
      extends Effect[
        CreateDatasetContentRequest,
        AwsError,
        zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly
      ]
  object UpdateChannel extends Effect[UpdateChannelRequest, AwsError, Unit]
  object CancelPipelineReprocessing
      extends Effect[
        CancelPipelineReprocessingRequest,
        AwsError,
        zio.aws.iotanalytics.model.CancelPipelineReprocessingResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, IoTAnalytics] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new IoTAnalytics {
          val api: IoTAnalyticsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : IoTAnalytics = this
          def createDataset(request: CreateDatasetRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly
          ] = proxy(CreateDataset, request)
          def listChannels(request: ListChannelsRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.ListChannelsResponse.ReadOnly
          ] = proxy(ListChannels, request)
          def createDatastore(request: CreateDatastoreRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.CreateDatastoreResponse.ReadOnly
          ] = proxy(CreateDatastore, request)
          def listDatastores(request: ListDatastoresRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.ListDatastoresResponse.ReadOnly
          ] = proxy(ListDatastores, request)
          def deleteDatastore(
              request: DeleteDatastoreRequest
          ): IO[AwsError, Unit] = proxy(DeleteDatastore, request)
          def describeLoggingOptions(
              request: DescribeLoggingOptionsRequest
          ): IO[
            AwsError,
            zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly
          ] = proxy(DescribeLoggingOptions, request)
          def updatePipeline(
              request: UpdatePipelineRequest
          ): IO[AwsError, Unit] = proxy(UpdatePipeline, request)
          def runPipelineActivity(request: RunPipelineActivityRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.RunPipelineActivityResponse.ReadOnly
          ] = proxy(RunPipelineActivity, request)
          def updateDatastore(
              request: UpdateDatastoreRequest
          ): IO[AwsError, Unit] = proxy(UpdateDatastore, request)
          def deleteChannel(request: DeleteChannelRequest): IO[AwsError, Unit] =
            proxy(DeleteChannel, request)
          def describeDataset(request: DescribeDatasetRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.DescribeDatasetResponse.ReadOnly
          ] = proxy(DescribeDataset, request)
          def describePipeline(request: DescribePipelineRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly
          ] = proxy(DescribePipeline, request)
          def listPipelines(request: ListPipelinesRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.ListPipelinesResponse.ReadOnly
          ] = proxy(ListPipelines, request)
          def putLoggingOptions(
              request: PutLoggingOptionsRequest
          ): IO[AwsError, Unit] = proxy(PutLoggingOptions, request)
          def describeDatastore(request: DescribeDatastoreRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.DescribeDatastoreResponse.ReadOnly
          ] = proxy(DescribeDatastore, request)
          def updateDataset(request: UpdateDatasetRequest): IO[AwsError, Unit] =
            proxy(UpdateDataset, request)
          def createChannel(request: CreateChannelRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.CreateChannelResponse.ReadOnly
          ] = proxy(CreateChannel, request)
          def startPipelineReprocessing(
              request: StartPipelineReprocessingRequest
          ): IO[
            AwsError,
            zio.aws.iotanalytics.model.StartPipelineReprocessingResponse.ReadOnly
          ] = proxy(StartPipelineReprocessing, request)
          def batchPutMessage(request: BatchPutMessageRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly
          ] = proxy(BatchPutMessage, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def listDatasetContents(request: ListDatasetContentsRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.ListDatasetContentsResponse.ReadOnly
          ] = proxy(ListDatasetContents, request)
          def listDatasets(request: ListDatasetsRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly
          ] = proxy(ListDatasets, request)
          def deletePipeline(
              request: DeletePipelineRequest
          ): IO[AwsError, Unit] = proxy(DeletePipeline, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def describeChannel(request: DescribeChannelRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.DescribeChannelResponse.ReadOnly
          ] = proxy(DescribeChannel, request)
          def getDatasetContent(
              request: GetDatasetContentRequest
          ): IO[AwsError, ReadOnly] = proxy(GetDatasetContent, request)
          def sampleChannelData(request: SampleChannelDataRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly
          ] = proxy(SampleChannelData, request)
          def deleteDataset(request: DeleteDatasetRequest): IO[AwsError, Unit] =
            proxy(DeleteDataset, request)
          def deleteDatasetContent(
              request: DeleteDatasetContentRequest
          ): IO[AwsError, Unit] = proxy(DeleteDatasetContent, request)
          def createPipeline(request: CreatePipelineRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.CreatePipelineResponse.ReadOnly
          ] = proxy(CreatePipeline, request)
          def createDatasetContent(request: CreateDatasetContentRequest): IO[
            AwsError,
            zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly
          ] = proxy(CreateDatasetContent, request)
          def updateChannel(request: UpdateChannelRequest): IO[AwsError, Unit] =
            proxy(UpdateChannel, request)
          def cancelPipelineReprocessing(
              request: CancelPipelineReprocessingRequest
          ): IO[
            AwsError,
            zio.aws.iotanalytics.model.CancelPipelineReprocessingResponse.ReadOnly
          ] = proxy(CancelPipelineReprocessing, request)
        }
      }
    }
  }
}
