package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.SqlQuery
import scala.jdk.CollectionConverters._
final case class SqlQueryDatasetAction(
    sqlQuery: SqlQuery,
    filters: Optional[Iterable[zio.aws.iotanalytics.model.QueryFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.SqlQueryDatasetAction = {
    import SqlQueryDatasetAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.SqlQueryDatasetAction
      .builder()
      .sqlQuery(SqlQuery.unwrap(sqlQuery): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.SqlQueryDatasetAction.ReadOnly =
    zio.aws.iotanalytics.model.SqlQueryDatasetAction.wrap(buildAwsValue())
}
object SqlQueryDatasetAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.SqlQueryDatasetAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.SqlQueryDatasetAction =
      zio.aws.iotanalytics.model.SqlQueryDatasetAction(
        sqlQuery,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def sqlQuery: SqlQuery
    def filters: Optional[List[zio.aws.iotanalytics.model.QueryFilter.ReadOnly]]
    def getSqlQuery: ZIO[Any, Nothing, SqlQuery] = ZIO.succeed(sqlQuery)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.QueryFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.SqlQueryDatasetAction
  ) extends zio.aws.iotanalytics.model.SqlQueryDatasetAction.ReadOnly {
    override val sqlQuery: SqlQuery =
      zio.aws.iotanalytics.model.primitives.SqlQuery(impl.sqlQuery())
    override val filters
        : Optional[List[zio.aws.iotanalytics.model.QueryFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.QueryFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.SqlQueryDatasetAction
  ): zio.aws.iotanalytics.model.SqlQueryDatasetAction.ReadOnly = new Wrapper(
    impl
  )
}
