package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{FilterExpression, ActivityName}
import scala.jdk.CollectionConverters._
final case class FilterActivity(
    name: ActivityName,
    filter: FilterExpression,
    next: Optional[ActivityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.FilterActivity = {
    import FilterActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.FilterActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .filter(FilterExpression.unwrap(filter): java.lang.String)
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.FilterActivity.ReadOnly =
    zio.aws.iotanalytics.model.FilterActivity.wrap(buildAwsValue())
}
object FilterActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.FilterActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.FilterActivity =
      zio.aws.iotanalytics.model
        .FilterActivity(name, filter, next.map(value => value))
    def name: ActivityName
    def filter: FilterExpression
    def next: Optional[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getFilter: ZIO[Any, Nothing, FilterExpression] = ZIO.succeed(filter)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.FilterActivity
  ) extends zio.aws.iotanalytics.model.FilterActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val filter: FilterExpression =
      zio.aws.iotanalytics.model.primitives.FilterExpression(impl.filter())
    override val next: Optional[ActivityName] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.FilterActivity
  ): zio.aws.iotanalytics.model.FilterActivity.ReadOnly = new Wrapper(impl)
}
