package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.MessagePayload
import scala.jdk.CollectionConverters._
final case class RunPipelineActivityRequest(
    pipelineActivity: zio.aws.iotanalytics.model.PipelineActivity,
    payloads: Iterable[MessagePayload]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest = {
    import RunPipelineActivityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest
      .builder()
      .pipelineActivity(pipelineActivity.buildAwsValue())
      .payloads(payloads.map { item =>
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(item.toArray[Byte])
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.RunPipelineActivityRequest.ReadOnly =
    zio.aws.iotanalytics.model.RunPipelineActivityRequest.wrap(buildAwsValue())
}
object RunPipelineActivityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.RunPipelineActivityRequest =
      zio.aws.iotanalytics.model
        .RunPipelineActivityRequest(pipelineActivity.asEditable, payloads)
    def pipelineActivity: zio.aws.iotanalytics.model.PipelineActivity.ReadOnly
    def payloads: List[MessagePayload]
    def getPipelineActivity: ZIO[
      Any,
      Nothing,
      zio.aws.iotanalytics.model.PipelineActivity.ReadOnly
    ] = ZIO.succeed(pipelineActivity)
    def getPayloads: ZIO[Any, Nothing, List[MessagePayload]] =
      ZIO.succeed(payloads)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest
  ) extends zio.aws.iotanalytics.model.RunPipelineActivityRequest.ReadOnly {
    override val pipelineActivity
        : zio.aws.iotanalytics.model.PipelineActivity.ReadOnly =
      zio.aws.iotanalytics.model.PipelineActivity.wrap(impl.pipelineActivity())
    override val payloads: List[MessagePayload] = impl
      .payloads()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.primitives
          .MessagePayload(zio.Chunk.fromArray(item.asByteArrayUnsafe()))
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.RunPipelineActivityRequest
  ): zio.aws.iotanalytics.model.RunPipelineActivityRequest.ReadOnly =
    new Wrapper(impl)
}
