package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchPutMessageResponse(
    batchPutMessageErrorEntries: Option[
      Iterable[zio.aws.iotanalytics.model.BatchPutMessageErrorEntry]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse = {
    import BatchPutMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse
      .builder()
      .optionallyWith(
        batchPutMessageErrorEntries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.batchPutMessageErrorEntries)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly =
    zio.aws.iotanalytics.model.BatchPutMessageResponse.wrap(buildAwsValue())
}
object BatchPutMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.BatchPutMessageResponse =
      zio.aws.iotanalytics.model.BatchPutMessageResponse(
        batchPutMessageErrorEntries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def batchPutMessageErrorEntries: Option[
      List[zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.ReadOnly]
    ]
    def getBatchPutMessageErrorEntries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "batchPutMessageErrorEntries",
      batchPutMessageErrorEntries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse
  ) extends zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly {
    override val batchPutMessageErrorEntries: Option[
      List[zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.ReadOnly]
    ] = scala
      .Option(impl.batchPutMessageErrorEntries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.BatchPutMessageErrorEntry.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.BatchPutMessageResponse
  ): zio.aws.iotanalytics.model.BatchPutMessageResponse.ReadOnly = new Wrapper(
    impl
  )
}
