package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLoggingOptionsResponse(
    loggingOptions: Option[zio.aws.iotanalytics.model.LoggingOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse = {
    import DescribeLoggingOptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse
      .builder()
      .optionallyWith(loggingOptions.map(value => value.buildAwsValue()))(
        _.loggingOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly =
    zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse
      .wrap(buildAwsValue())
}
object DescribeLoggingOptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse =
      zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse(
        loggingOptions.map(value => value.asEditable)
      )
    def loggingOptions
        : Option[zio.aws.iotanalytics.model.LoggingOptions.ReadOnly]
    def getLoggingOptions: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.LoggingOptions.ReadOnly
    ] = AwsError.unwrapOptionField("loggingOptions", loggingOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse
  ) extends zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly {
    override val loggingOptions
        : Option[zio.aws.iotanalytics.model.LoggingOptions.ReadOnly] = scala
      .Option(impl.loggingOptions())
      .map(value => zio.aws.iotanalytics.model.LoggingOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribeLoggingOptionsResponse
  ): zio.aws.iotanalytics.model.DescribeLoggingOptionsResponse.ReadOnly =
    new Wrapper(impl)
}
