package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  EndTime,
  StartTime,
  MaxMessages,
  ChannelName
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SampleChannelDataRequest(
    channelName: ChannelName,
    maxMessages: Option[MaxMessages] = None,
    startTime: Option[StartTime] = None,
    endTime: Option[EndTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest = {
    import SampleChannelDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .optionallyWith(
        maxMessages.map(value => MaxMessages.unwrap(value): Integer)
      )(_.maxMessages)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.SampleChannelDataRequest.ReadOnly =
    zio.aws.iotanalytics.model.SampleChannelDataRequest.wrap(buildAwsValue())
}
object SampleChannelDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.SampleChannelDataRequest =
      zio.aws.iotanalytics.model.SampleChannelDataRequest(
        channelName,
        maxMessages.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def channelName: ChannelName
    def maxMessages: Option[MaxMessages]
    def startTime: Option[StartTime]
    def endTime: Option[EndTime]
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getMaxMessages: ZIO[Any, AwsError, MaxMessages] =
      AwsError.unwrapOptionField("maxMessages", maxMessages)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest
  ) extends zio.aws.iotanalytics.model.SampleChannelDataRequest.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
    override val maxMessages: Option[MaxMessages] = scala
      .Option(impl.maxMessages())
      .map(value => zio.aws.iotanalytics.model.primitives.MaxMessages(value))
    override val startTime: Option[StartTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.iotanalytics.model.primitives.StartTime(value))
    override val endTime: Option[EndTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.iotanalytics.model.primitives.EndTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataRequest
  ): zio.aws.iotanalytics.model.SampleChannelDataRequest.ReadOnly = new Wrapper(
    impl
  )
}
