package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{
  MathExpression,
  AttributeName,
  ActivityName
}
import scala.jdk.CollectionConverters._
final case class MathActivity(
    name: ActivityName,
    attribute: AttributeName,
    math: MathExpression,
    next: Option[ActivityName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.MathActivity = {
    import MathActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.MathActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .attribute(AttributeName.unwrap(attribute): java.lang.String)
      .math(MathExpression.unwrap(math): java.lang.String)
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.MathActivity.ReadOnly =
    zio.aws.iotanalytics.model.MathActivity.wrap(buildAwsValue())
}
object MathActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.MathActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.MathActivity =
      zio.aws.iotanalytics.model.MathActivity(
        name,
        attribute,
        math,
        next.map(value => value)
      )
    def name: ActivityName
    def attribute: AttributeName
    def math: MathExpression
    def next: Option[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getAttribute: ZIO[Any, Nothing, AttributeName] = ZIO.succeed(attribute)
    def getMath: ZIO[Any, Nothing, MathExpression] = ZIO.succeed(math)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.MathActivity
  ) extends zio.aws.iotanalytics.model.MathActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val attribute: AttributeName =
      zio.aws.iotanalytics.model.primitives.AttributeName(impl.attribute())
    override val math: MathExpression =
      zio.aws.iotanalytics.model.primitives.MathExpression(impl.math())
    override val next: Option[ActivityName] = scala
      .Option(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.MathActivity
  ): zio.aws.iotanalytics.model.MathActivity.ReadOnly = new Wrapper(impl)
}
