package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  DatasetArn,
  DatasetName
}
import scala.jdk.CollectionConverters._
final case class Dataset(
    name: Option[DatasetName] = None,
    arn: Option[DatasetArn] = None,
    actions: Option[Iterable[zio.aws.iotanalytics.model.DatasetAction]] = None,
    triggers: Option[Iterable[zio.aws.iotanalytics.model.DatasetTrigger]] =
      None,
    contentDeliveryRules: Option[
      Iterable[zio.aws.iotanalytics.model.DatasetContentDeliveryRule]
    ] = None,
    status: Option[zio.aws.iotanalytics.model.DatasetStatus] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None,
    versioningConfiguration: Option[
      zio.aws.iotanalytics.model.VersioningConfiguration
    ] = None,
    lateDataRules: Option[Iterable[zio.aws.iotanalytics.model.LateDataRule]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Dataset
      .builder()
      .optionallyWith(
        name.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        arn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        contentDeliveryRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contentDeliveryRules)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        versioningConfiguration.map(value => value.buildAwsValue())
      )(_.versioningConfiguration)
      .optionallyWith(
        lateDataRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lateDataRules)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Dataset.ReadOnly =
    zio.aws.iotanalytics.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Dataset
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Dataset =
      zio.aws.iotanalytics.model.Dataset(
        name.map(value => value),
        arn.map(value => value),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        contentDeliveryRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        versioningConfiguration.map(value => value.asEditable),
        lateDataRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[DatasetName]
    def arn: Option[DatasetArn]
    def actions: Option[List[zio.aws.iotanalytics.model.DatasetAction.ReadOnly]]
    def triggers
        : Option[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]]
    def contentDeliveryRules: Option[
      List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly]
    ]
    def status: Option[zio.aws.iotanalytics.model.DatasetStatus]
    def creationTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def versioningConfiguration
        : Option[zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly]
    def lateDataRules
        : Option[List[zio.aws.iotanalytics.model.LateDataRule.ReadOnly]]
    def getName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("name", name)
    def getArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetAction.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getContentDeliveryRules: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("contentDeliveryRules", contentDeliveryRules)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getVersioningConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "versioningConfiguration",
      versioningConfiguration
    )
    def getLateDataRules: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.LateDataRule.ReadOnly
    ]] = AwsError.unwrapOptionField("lateDataRules", lateDataRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Dataset
  ) extends zio.aws.iotanalytics.model.Dataset.ReadOnly {
    override val name: Option[DatasetName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.DatasetName(value))
    override val arn: Option[DatasetArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.DatasetArn(value))
    override val actions
        : Option[List[zio.aws.iotanalytics.model.DatasetAction.ReadOnly]] =
      scala
        .Option(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetAction.wrap(item)
          }.toList
        )
    override val triggers
        : Option[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]] =
      scala
        .Option(impl.triggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetTrigger.wrap(item)
          }.toList
        )
    override val contentDeliveryRules: Option[
      List[zio.aws.iotanalytics.model.DatasetContentDeliveryRule.ReadOnly]
    ] = scala
      .Option(impl.contentDeliveryRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.DatasetContentDeliveryRule.wrap(item)
        }.toList
      )
    override val status: Option[zio.aws.iotanalytics.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotanalytics.model.DatasetStatus.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val versioningConfiguration
        : Option[zio.aws.iotanalytics.model.VersioningConfiguration.ReadOnly] =
      scala
        .Option(impl.versioningConfiguration())
        .map(value =>
          zio.aws.iotanalytics.model.VersioningConfiguration.wrap(value)
        )
    override val lateDataRules
        : Option[List[zio.aws.iotanalytics.model.LateDataRule.ReadOnly]] = scala
      .Option(impl.lateDataRules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.LateDataRule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Dataset
  ): zio.aws.iotanalytics.model.Dataset.ReadOnly = new Wrapper(impl)
}
