package zio.aws.iotanalytics.model
import scala.jdk.CollectionConverters._
sealed trait ReprocessingStatus {
  def unwrap
      : software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus
}
object ReprocessingStatus {
  def wrap(
      value: software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus
  ): zio.aws.iotanalytics.model.ReprocessingStatus = value match {
    case software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.CANCELLED =>
      val r = CANCELLED
      r
    case software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iotanalytics.model.ReprocessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus =
      software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.iotanalytics.model.ReprocessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus =
      software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.RUNNING
  }
  case object SUCCEEDED extends zio.aws.iotanalytics.model.ReprocessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus =
      software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.SUCCEEDED
  }
  case object CANCELLED extends zio.aws.iotanalytics.model.ReprocessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus =
      software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.CANCELLED
  }
  case object FAILED extends zio.aws.iotanalytics.model.ReprocessingStatus {
    override def unwrap
        : software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus =
      software.amazon.awssdk.services.iotanalytics.model.ReprocessingStatus.FAILED
  }
}
