package zio.aws.iotanalytics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.VolumeSizeInGB
import scala.jdk.CollectionConverters._
final case class ResourceConfiguration(
    computeType: zio.aws.iotanalytics.model.ComputeType,
    volumeSizeInGB: VolumeSizeInGB
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ResourceConfiguration = {
    import ResourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ResourceConfiguration
      .builder()
      .computeType(computeType.unwrap)
      .volumeSizeInGB(VolumeSizeInGB.unwrap(volumeSizeInGB): Integer)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ResourceConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.ResourceConfiguration.wrap(buildAwsValue())
}
object ResourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ResourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ResourceConfiguration =
      zio.aws.iotanalytics.model
        .ResourceConfiguration(computeType, volumeSizeInGB)
    def computeType: zio.aws.iotanalytics.model.ComputeType
    def volumeSizeInGB: VolumeSizeInGB
    def getComputeType
        : ZIO[Any, Nothing, zio.aws.iotanalytics.model.ComputeType] =
      ZIO.succeed(computeType)
    def getVolumeSizeInGB: ZIO[Any, Nothing, VolumeSizeInGB] =
      ZIO.succeed(volumeSizeInGB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ResourceConfiguration
  ) extends zio.aws.iotanalytics.model.ResourceConfiguration.ReadOnly {
    override val computeType: zio.aws.iotanalytics.model.ComputeType =
      zio.aws.iotanalytics.model.ComputeType.wrap(impl.computeType())
    override val volumeSizeInGB: VolumeSizeInGB =
      zio.aws.iotanalytics.model.primitives
        .VolumeSizeInGB(impl.volumeSizeInGB())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ResourceConfiguration
  ): zio.aws.iotanalytics.model.ResourceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
