package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LateDataRuleConfiguration(
    deltaTimeSessionWindowConfiguration: Option[
      zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.LateDataRuleConfiguration = {
    import LateDataRuleConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.LateDataRuleConfiguration
      .builder()
      .optionallyWith(
        deltaTimeSessionWindowConfiguration.map(value => value.buildAwsValue())
      )(_.deltaTimeSessionWindowConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.LateDataRuleConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.LateDataRuleConfiguration.wrap(buildAwsValue())
}
object LateDataRuleConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.LateDataRuleConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.LateDataRuleConfiguration =
      zio.aws.iotanalytics.model.LateDataRuleConfiguration(
        deltaTimeSessionWindowConfiguration.map(value => value.asEditable)
      )
    def deltaTimeSessionWindowConfiguration: Option[
      zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration.ReadOnly
    ]
    def getDeltaTimeSessionWindowConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "deltaTimeSessionWindowConfiguration",
      deltaTimeSessionWindowConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.LateDataRuleConfiguration
  ) extends zio.aws.iotanalytics.model.LateDataRuleConfiguration.ReadOnly {
    override val deltaTimeSessionWindowConfiguration: Option[
      zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration.ReadOnly
    ] = scala
      .Option(impl.deltaTimeSessionWindowConfiguration())
      .map(value =>
        zio.aws.iotanalytics.model.DeltaTimeSessionWindowConfiguration
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.LateDataRuleConfiguration
  ): zio.aws.iotanalytics.model.LateDataRuleConfiguration.ReadOnly =
    new Wrapper(impl)
}
