package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListDatasetsResponse(
    datasetSummaries: Option[
      Iterable[zio.aws.iotanalytics.model.DatasetSummary]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse = {
    import ListDatasetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse
      .builder()
      .optionallyWith(
        datasetSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.datasetSummaries)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly =
    zio.aws.iotanalytics.model.ListDatasetsResponse.wrap(buildAwsValue())
}
object ListDatasetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ListDatasetsResponse =
      zio.aws.iotanalytics.model.ListDatasetsResponse(
        datasetSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def datasetSummaries
        : Option[List[zio.aws.iotanalytics.model.DatasetSummary.ReadOnly]]
    def nextToken: Option[NextToken]
    def getDatasetSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("datasetSummaries", datasetSummaries)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse
  ) extends zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly {
    override val datasetSummaries
        : Option[List[zio.aws.iotanalytics.model.DatasetSummary.ReadOnly]] =
      scala
        .Option(impl.datasetSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetSummary.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.iotanalytics.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ListDatasetsResponse
  ): zio.aws.iotanalytics.model.ListDatasetsResponse.ReadOnly = new Wrapper(
    impl
  )
}
