package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.Timestamp
import scala.jdk.CollectionConverters._
final case class GetDatasetContentResponse(
    entries: Option[Iterable[zio.aws.iotanalytics.model.DatasetEntry]] = None,
    timestamp: Option[Timestamp] = None,
    status: Option[zio.aws.iotanalytics.model.DatasetContentStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse = {
    import GetDatasetContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
      .builder()
      .optionallyWith(
        entries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.entries)
      .optionallyWith(timestamp.map(value => Timestamp.unwrap(value): Instant))(
        _.timestamp
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly =
    zio.aws.iotanalytics.model.GetDatasetContentResponse.wrap(buildAwsValue())
}
object GetDatasetContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.GetDatasetContentResponse =
      zio.aws.iotanalytics.model.GetDatasetContentResponse(
        entries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        timestamp.map(value => value),
        status.map(value => value.asEditable)
      )
    def entries: Option[List[zio.aws.iotanalytics.model.DatasetEntry.ReadOnly]]
    def timestamp: Option[Timestamp]
    def status: Option[zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly]
    def getEntries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("entries", entries)
    def getTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
  ) extends zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly {
    override val entries
        : Option[List[zio.aws.iotanalytics.model.DatasetEntry.ReadOnly]] = scala
      .Option(impl.entries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.DatasetEntry.wrap(item)
        }.toList
      )
    override val timestamp: Option[Timestamp] = scala
      .Option(impl.timestamp())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val status
        : Option[zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value =>
          zio.aws.iotanalytics.model.DatasetContentStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.GetDatasetContentResponse
  ): zio.aws.iotanalytics.model.GetDatasetContentResponse.ReadOnly =
    new Wrapper(impl)
}
