package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{Timestamp, DatasetName}
import scala.jdk.CollectionConverters._
final case class DatasetSummary(
    datasetName: Option[DatasetName] = None,
    status: Option[zio.aws.iotanalytics.model.DatasetStatus] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    triggers: Option[Iterable[zio.aws.iotanalytics.model.DatasetTrigger]] =
      None,
    actions: Option[Iterable[zio.aws.iotanalytics.model.DatasetActionSummary]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetSummary = {
    import DatasetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetSummary
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetSummary.ReadOnly =
    zio.aws.iotanalytics.model.DatasetSummary.wrap(buildAwsValue())
}
object DatasetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetSummary =
      zio.aws.iotanalytics.model.DatasetSummary(
        datasetName.map(value => value),
        status.map(value => value),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def datasetName: Option[DatasetName]
    def status: Option[zio.aws.iotanalytics.model.DatasetStatus]
    def creationTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def triggers
        : Option[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]]
    def actions
        : Option[List[zio.aws.iotanalytics.model.DatasetActionSummary.ReadOnly]]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatasetStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getActions: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.DatasetActionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetSummary
  ) extends zio.aws.iotanalytics.model.DatasetSummary.ReadOnly {
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value => zio.aws.iotanalytics.model.primitives.DatasetName(value))
    override val status: Option[zio.aws.iotanalytics.model.DatasetStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotanalytics.model.DatasetStatus.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val triggers
        : Option[List[zio.aws.iotanalytics.model.DatasetTrigger.ReadOnly]] =
      scala
        .Option(impl.triggers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.DatasetTrigger.wrap(item)
          }.toList
        )
    override val actions: Option[
      List[zio.aws.iotanalytics.model.DatasetActionSummary.ReadOnly]
    ] = scala
      .Option(impl.actions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.DatasetActionSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetSummary
  ): zio.aws.iotanalytics.model.DatasetSummary.ReadOnly = new Wrapper(impl)
}
