package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.PipelineName
import scala.jdk.CollectionConverters._
final case class CreatePipelineRequest(
    pipelineName: PipelineName,
    pipelineActivities: Iterable[zio.aws.iotanalytics.model.PipelineActivity],
    tags: Option[Iterable[zio.aws.iotanalytics.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .pipelineActivities(pipelineActivities.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreatePipelineRequest.ReadOnly =
    zio.aws.iotanalytics.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreatePipelineRequest =
      zio.aws.iotanalytics.model.CreatePipelineRequest(
        pipelineName,
        pipelineActivities.map { item =>
          item.asEditable
        },
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineName: PipelineName
    def pipelineActivities
        : List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly]
    def tags: Option[List[zio.aws.iotanalytics.model.Tag.ReadOnly]]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getPipelineActivities: ZIO[Any, Nothing, List[
      zio.aws.iotanalytics.model.PipelineActivity.ReadOnly
    ]] = ZIO.succeed(pipelineActivities)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest
  ) extends zio.aws.iotanalytics.model.CreatePipelineRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.iotanalytics.model.primitives.PipelineName(impl.pipelineName())
    override val pipelineActivities
        : List[zio.aws.iotanalytics.model.PipelineActivity.ReadOnly] = impl
      .pipelineActivities()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.PipelineActivity.wrap(item)
      }
      .toList
    override val tags: Option[List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreatePipelineRequest
  ): zio.aws.iotanalytics.model.CreatePipelineRequest.ReadOnly = new Wrapper(
    impl
  )
}
