package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  DatastoreArn,
  DatastoreName
}
import scala.jdk.CollectionConverters._
final case class Datastore(
    name: Option[DatastoreName] = None,
    storage: Option[zio.aws.iotanalytics.model.DatastoreStorage] = None,
    arn: Option[DatastoreArn] = None,
    status: Option[zio.aws.iotanalytics.model.DatastoreStatus] = None,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    lastMessageArrivalTime: Option[Timestamp] = None,
    fileFormatConfiguration: Option[
      zio.aws.iotanalytics.model.FileFormatConfiguration
    ] = None,
    datastorePartitions: Option[
      zio.aws.iotanalytics.model.DatastorePartitions
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Datastore = {
    import Datastore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Datastore
      .builder()
      .optionallyWith(
        name.map(value => DatastoreName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .optionallyWith(
        arn.map(value => DatastoreArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .optionallyWith(
        fileFormatConfiguration.map(value => value.buildAwsValue())
      )(_.fileFormatConfiguration)
      .optionallyWith(datastorePartitions.map(value => value.buildAwsValue()))(
        _.datastorePartitions
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Datastore.ReadOnly =
    zio.aws.iotanalytics.model.Datastore.wrap(buildAwsValue())
}
object Datastore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Datastore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Datastore =
      zio.aws.iotanalytics.model.Datastore(
        name.map(value => value),
        storage.map(value => value.asEditable),
        arn.map(value => value),
        status.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value),
        fileFormatConfiguration.map(value => value.asEditable),
        datastorePartitions.map(value => value.asEditable)
      )
    def name: Option[DatastoreName]
    def storage: Option[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly]
    def arn: Option[DatastoreArn]
    def status: Option[zio.aws.iotanalytics.model.DatastoreStatus]
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def creationTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def lastMessageArrivalTime: Option[Timestamp]
    def fileFormatConfiguration
        : Option[zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly]
    def datastorePartitions
        : Option[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly]
    def getName: ZIO[Any, AwsError, DatastoreName] =
      AwsError.unwrapOptionField("name", name)
    def getStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly
    ] = AwsError.unwrapOptionField("storage", storage)
    def getArn: ZIO[Any, AwsError, DatastoreArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatastoreStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
    def getFileFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fileFormatConfiguration",
      fileFormatConfiguration
    )
    def getDatastorePartitions: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly
    ] = AwsError.unwrapOptionField("datastorePartitions", datastorePartitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Datastore
  ) extends zio.aws.iotanalytics.model.Datastore.ReadOnly {
    override val name: Option[DatastoreName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreName(value))
    override val storage
        : Option[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly] = scala
      .Option(impl.storage())
      .map(value => zio.aws.iotanalytics.model.DatastoreStorage.wrap(value))
    override val arn: Option[DatastoreArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.DatastoreArn(value))
    override val status: Option[zio.aws.iotanalytics.model.DatastoreStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotanalytics.model.DatastoreStatus.wrap(value))
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Option[Timestamp] = scala
      .Option(impl.lastMessageArrivalTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val fileFormatConfiguration
        : Option[zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly] =
      scala
        .Option(impl.fileFormatConfiguration())
        .map(value =>
          zio.aws.iotanalytics.model.FileFormatConfiguration.wrap(value)
        )
    override val datastorePartitions
        : Option[zio.aws.iotanalytics.model.DatastorePartitions.ReadOnly] =
      scala
        .Option(impl.datastorePartitions())
        .map(value =>
          zio.aws.iotanalytics.model.DatastorePartitions.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Datastore
  ): zio.aws.iotanalytics.model.Datastore.ReadOnly = new Wrapper(impl)
}
