package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.ChannelName
import scala.jdk.CollectionConverters._
final case class CreateChannelRequest(
    channelName: ChannelName,
    channelStorage: Option[zio.aws.iotanalytics.model.ChannelStorage] = None,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None,
    tags: Option[Iterable[zio.aws.iotanalytics.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest = {
    import CreateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest
      .builder()
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .optionallyWith(channelStorage.map(value => value.buildAwsValue()))(
        _.channelStorage
      )
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreateChannelRequest.ReadOnly =
    zio.aws.iotanalytics.model.CreateChannelRequest.wrap(buildAwsValue())
}
object CreateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateChannelRequest =
      zio.aws.iotanalytics.model.CreateChannelRequest(
        channelName,
        channelStorage.map(value => value.asEditable),
        retentionPeriod.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channelName: ChannelName
    def channelStorage
        : Option[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly]
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def tags: Option[List[zio.aws.iotanalytics.model.Tag.ReadOnly]]
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getChannelStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStorage.ReadOnly
    ] = AwsError.unwrapOptionField("channelStorage", channelStorage)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest
  ) extends zio.aws.iotanalytics.model.CreateChannelRequest.ReadOnly {
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
    override val channelStorage
        : Option[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly] = scala
      .Option(impl.channelStorage())
      .map(value => zio.aws.iotanalytics.model.ChannelStorage.wrap(value))
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val tags: Option[List[zio.aws.iotanalytics.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iotanalytics.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateChannelRequest
  ): zio.aws.iotanalytics.model.CreateChannelRequest.ReadOnly = new Wrapper(
    impl
  )
}
