package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{Timestamp, SizeInBytes}
import scala.jdk.CollectionConverters._
final case class EstimatedResourceSize(
    estimatedSizeInBytes: Option[SizeInBytes] = None,
    estimatedOn: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.EstimatedResourceSize = {
    import EstimatedResourceSize.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.EstimatedResourceSize
      .builder()
      .optionallyWith(
        estimatedSizeInBytes.map(value =>
          SizeInBytes.unwrap(value): java.lang.Double
        )
      )(_.estimatedSizeInBytes)
      .optionallyWith(
        estimatedOn.map(value => Timestamp.unwrap(value): Instant)
      )(_.estimatedOn)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.EstimatedResourceSize.ReadOnly =
    zio.aws.iotanalytics.model.EstimatedResourceSize.wrap(buildAwsValue())
}
object EstimatedResourceSize {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.EstimatedResourceSize
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.EstimatedResourceSize =
      zio.aws.iotanalytics.model.EstimatedResourceSize(
        estimatedSizeInBytes.map(value => value),
        estimatedOn.map(value => value)
      )
    def estimatedSizeInBytes: Option[SizeInBytes]
    def estimatedOn: Option[Timestamp]
    def getEstimatedSizeInBytes: ZIO[Any, AwsError, SizeInBytes] =
      AwsError.unwrapOptionField("estimatedSizeInBytes", estimatedSizeInBytes)
    def getEstimatedOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("estimatedOn", estimatedOn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.EstimatedResourceSize
  ) extends zio.aws.iotanalytics.model.EstimatedResourceSize.ReadOnly {
    override val estimatedSizeInBytes: Option[SizeInBytes] = scala
      .Option(impl.estimatedSizeInBytes())
      .map(value => zio.aws.iotanalytics.model.primitives.SizeInBytes(value))
    override val estimatedOn: Option[Timestamp] = scala
      .Option(impl.estimatedOn())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.EstimatedResourceSize
  ): zio.aws.iotanalytics.model.EstimatedResourceSize.ReadOnly = new Wrapper(
    impl
  )
}
