package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{ChannelName, ActivityName}
import scala.jdk.CollectionConverters._
final case class ChannelActivity(
    name: ActivityName,
    channelName: ChannelName,
    next: Option[ActivityName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ChannelActivity = {
    import ChannelActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ChannelActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .channelName(ChannelName.unwrap(channelName): java.lang.String)
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ChannelActivity.ReadOnly =
    zio.aws.iotanalytics.model.ChannelActivity.wrap(buildAwsValue())
}
object ChannelActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ChannelActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ChannelActivity =
      zio.aws.iotanalytics.model
        .ChannelActivity(name, channelName, next.map(value => value))
    def name: ActivityName
    def channelName: ChannelName
    def next: Option[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getChannelName: ZIO[Any, Nothing, ChannelName] =
      ZIO.succeed(channelName)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelActivity
  ) extends zio.aws.iotanalytics.model.ChannelActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val channelName: ChannelName =
      zio.aws.iotanalytics.model.primitives.ChannelName(impl.channelName())
    override val next: Option[ActivityName] = scala
      .Option(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ChannelActivity
  ): zio.aws.iotanalytics.model.ChannelActivity.ReadOnly = new Wrapper(impl)
}
