package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.MessagePayload
import scala.jdk.CollectionConverters._
final case class SampleChannelDataResponse(
    payloads: Option[Iterable[MessagePayload]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse = {
    import SampleChannelDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse
      .builder()
      .optionallyWith(
        payloads.map(value =>
          value.map { item =>
            software.amazon.awssdk.core.SdkBytes
              .fromByteArrayUnsafe(item.toArray[Byte])
          }.asJavaCollection
        )
      )(_.payloads)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly =
    zio.aws.iotanalytics.model.SampleChannelDataResponse.wrap(buildAwsValue())
}
object SampleChannelDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.SampleChannelDataResponse =
      zio.aws.iotanalytics.model
        .SampleChannelDataResponse(payloads.map(value => value))
    def payloads: Option[List[MessagePayload]]
    def getPayloads: ZIO[Any, AwsError, List[MessagePayload]] =
      AwsError.unwrapOptionField("payloads", payloads)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse
  ) extends zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly {
    override val payloads: Option[List[MessagePayload]] = scala
      .Option(impl.payloads())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.primitives
            .MessagePayload(zio.Chunk.fromArray(item.asByteArrayUnsafe()))
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.SampleChannelDataResponse
  ): zio.aws.iotanalytics.model.SampleChannelDataResponse.ReadOnly =
    new Wrapper(impl)
}
