package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{Timestamp, ReprocessingId}
import scala.jdk.CollectionConverters._
final case class ReprocessingSummary(
    id: Option[ReprocessingId] = None,
    status: Option[zio.aws.iotanalytics.model.ReprocessingStatus] = None,
    creationTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary = {
    import ReprocessingSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary
      .builder()
      .optionallyWith(
        id.map(value => ReprocessingId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly =
    zio.aws.iotanalytics.model.ReprocessingSummary.wrap(buildAwsValue())
}
object ReprocessingSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ReprocessingSummary =
      zio.aws.iotanalytics.model.ReprocessingSummary(
        id.map(value => value),
        status.map(value => value),
        creationTime.map(value => value)
      )
    def id: Option[ReprocessingId]
    def status: Option[zio.aws.iotanalytics.model.ReprocessingStatus]
    def creationTime: Option[Timestamp]
    def getId: ZIO[Any, AwsError, ReprocessingId] =
      AwsError.unwrapOptionField("id", id)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.ReprocessingStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary
  ) extends zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly {
    override val id: Option[ReprocessingId] = scala
      .Option(impl.id())
      .map(value => zio.aws.iotanalytics.model.primitives.ReprocessingId(value))
    override val status: Option[zio.aws.iotanalytics.model.ReprocessingStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotanalytics.model.ReprocessingStatus.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ReprocessingSummary
  ): zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly = new Wrapper(impl)
}
