package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{DatastoreName, ActivityName}
import scala.jdk.CollectionConverters._
final case class DatastoreActivity(
    name: ActivityName,
    datastoreName: DatastoreName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatastoreActivity = {
    import DatastoreActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatastoreActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .datastoreName(DatastoreName.unwrap(datastoreName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly =
    zio.aws.iotanalytics.model.DatastoreActivity.wrap(buildAwsValue())
}
object DatastoreActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatastoreActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatastoreActivity =
      zio.aws.iotanalytics.model.DatastoreActivity(name, datastoreName)
    def name: ActivityName
    def datastoreName: DatastoreName
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getDatastoreName: ZIO[Any, Nothing, DatastoreName] =
      ZIO.succeed(datastoreName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreActivity
  ) extends zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val datastoreName: DatastoreName =
      zio.aws.iotanalytics.model.primitives.DatastoreName(impl.datastoreName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatastoreActivity
  ): zio.aws.iotanalytics.model.DatastoreActivity.ReadOnly = new Wrapper(impl)
}
