package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{DatasetArn, DatasetName}
import scala.jdk.CollectionConverters._
final case class CreateDatasetResponse(
    datasetName: Option[DatasetName] = None,
    datasetArn: Option[DatasetArn] = None,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse = {
    import CreateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        datasetArn.map(value => DatasetArn.unwrap(value): java.lang.String)
      )(_.datasetArn)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly =
    zio.aws.iotanalytics.model.CreateDatasetResponse.wrap(buildAwsValue())
}
object CreateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateDatasetResponse =
      zio.aws.iotanalytics.model.CreateDatasetResponse(
        datasetName.map(value => value),
        datasetArn.map(value => value),
        retentionPeriod.map(value => value.asEditable)
      )
    def datasetName: Option[DatasetName]
    def datasetArn: Option[DatasetArn]
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getDatasetArn: ZIO[Any, AwsError, DatasetArn] =
      AwsError.unwrapOptionField("datasetArn", datasetArn)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse
  ) extends zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly {
    override val datasetName: Option[DatasetName] = scala
      .Option(impl.datasetName())
      .map(value => zio.aws.iotanalytics.model.primitives.DatasetName(value))
    override val datasetArn: Option[DatasetArn] = scala
      .Option(impl.datasetArn())
      .map(value => zio.aws.iotanalytics.model.primitives.DatasetArn(value))
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetResponse
  ): zio.aws.iotanalytics.model.CreateDatasetResponse.ReadOnly = new Wrapper(
    impl
  )
}
