package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.DatastoreName
import scala.jdk.CollectionConverters._
final case class UpdateDatastoreRequest(
    datastoreName: DatastoreName,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None,
    datastoreStorage: Option[zio.aws.iotanalytics.model.DatastoreStorage] =
      None,
    fileFormatConfiguration: Option[
      zio.aws.iotanalytics.model.FileFormatConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest = {
    import UpdateDatastoreRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest
      .builder()
      .datastoreName(DatastoreName.unwrap(datastoreName): java.lang.String)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(datastoreStorage.map(value => value.buildAwsValue()))(
        _.datastoreStorage
      )
      .optionallyWith(
        fileFormatConfiguration.map(value => value.buildAwsValue())
      )(_.fileFormatConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.UpdateDatastoreRequest.ReadOnly =
    zio.aws.iotanalytics.model.UpdateDatastoreRequest.wrap(buildAwsValue())
}
object UpdateDatastoreRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.UpdateDatastoreRequest =
      zio.aws.iotanalytics.model.UpdateDatastoreRequest(
        datastoreName,
        retentionPeriod.map(value => value.asEditable),
        datastoreStorage.map(value => value.asEditable),
        fileFormatConfiguration.map(value => value.asEditable)
      )
    def datastoreName: DatastoreName
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def datastoreStorage
        : Option[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly]
    def fileFormatConfiguration
        : Option[zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly]
    def getDatastoreName: ZIO[Any, Nothing, DatastoreName] =
      ZIO.succeed(datastoreName)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getDatastoreStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly
    ] = AwsError.unwrapOptionField("datastoreStorage", datastoreStorage)
    def getFileFormatConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "fileFormatConfiguration",
      fileFormatConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest
  ) extends zio.aws.iotanalytics.model.UpdateDatastoreRequest.ReadOnly {
    override val datastoreName: DatastoreName =
      zio.aws.iotanalytics.model.primitives.DatastoreName(impl.datastoreName())
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val datastoreStorage
        : Option[zio.aws.iotanalytics.model.DatastoreStorage.ReadOnly] = scala
      .Option(impl.datastoreStorage())
      .map(value => zio.aws.iotanalytics.model.DatastoreStorage.wrap(value))
    override val fileFormatConfiguration
        : Option[zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly] =
      scala
        .Option(impl.fileFormatConfiguration())
        .map(value =>
          zio.aws.iotanalytics.model.FileFormatConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.UpdateDatastoreRequest
  ): zio.aws.iotanalytics.model.UpdateDatastoreRequest.ReadOnly = new Wrapper(
    impl
  )
}
