package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{
  DatasetContentVersion,
  DatasetName
}
import scala.jdk.CollectionConverters._
final case class CreateDatasetContentRequest(
    datasetName: DatasetName,
    versionId: Option[DatasetContentVersion] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest = {
    import CreateDatasetContentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest
      .builder()
      .datasetName(DatasetName.unwrap(datasetName): java.lang.String)
      .optionallyWith(
        versionId.map(value =>
          DatasetContentVersion.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.CreateDatasetContentRequest.ReadOnly =
    zio.aws.iotanalytics.model.CreateDatasetContentRequest.wrap(buildAwsValue())
}
object CreateDatasetContentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateDatasetContentRequest =
      zio.aws.iotanalytics.model
        .CreateDatasetContentRequest(datasetName, versionId.map(value => value))
    def datasetName: DatasetName
    def versionId: Option[DatasetContentVersion]
    def getDatasetName: ZIO[Any, Nothing, DatasetName] =
      ZIO.succeed(datasetName)
    def getVersionId: ZIO[Any, AwsError, DatasetContentVersion] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest
  ) extends zio.aws.iotanalytics.model.CreateDatasetContentRequest.ReadOnly {
    override val datasetName: DatasetName =
      zio.aws.iotanalytics.model.primitives.DatasetName(impl.datasetName())
    override val versionId: Option[DatasetContentVersion] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.DatasetContentVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentRequest
  ): zio.aws.iotanalytics.model.CreateDatasetContentRequest.ReadOnly =
    new Wrapper(impl)
}
