package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{RoleArn, Image}
import scala.jdk.CollectionConverters._
final case class ContainerDatasetAction(
    image: Image,
    executionRoleArn: RoleArn,
    resourceConfiguration: zio.aws.iotanalytics.model.ResourceConfiguration,
    variables: Option[Iterable[zio.aws.iotanalytics.model.Variable]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.ContainerDatasetAction = {
    import ContainerDatasetAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.ContainerDatasetAction
      .builder()
      .image(Image.unwrap(image): java.lang.String)
      .executionRoleArn(RoleArn.unwrap(executionRoleArn): java.lang.String)
      .resourceConfiguration(resourceConfiguration.buildAwsValue())
      .optionallyWith(
        variables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variables)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.ContainerDatasetAction.ReadOnly =
    zio.aws.iotanalytics.model.ContainerDatasetAction.wrap(buildAwsValue())
}
object ContainerDatasetAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.ContainerDatasetAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.ContainerDatasetAction =
      zio.aws.iotanalytics.model.ContainerDatasetAction(
        image,
        executionRoleArn,
        resourceConfiguration.asEditable,
        variables.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def image: Image
    def executionRoleArn: RoleArn
    def resourceConfiguration
        : zio.aws.iotanalytics.model.ResourceConfiguration.ReadOnly
    def variables: Option[List[zio.aws.iotanalytics.model.Variable.ReadOnly]]
    def getImage: ZIO[Any, Nothing, Image] = ZIO.succeed(image)
    def getExecutionRoleArn: ZIO[Any, Nothing, RoleArn] =
      ZIO.succeed(executionRoleArn)
    def getResourceConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.iotanalytics.model.ResourceConfiguration.ReadOnly
    ] = ZIO.succeed(resourceConfiguration)
    def getVariables: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.Variable.ReadOnly
    ]] = AwsError.unwrapOptionField("variables", variables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.ContainerDatasetAction
  ) extends zio.aws.iotanalytics.model.ContainerDatasetAction.ReadOnly {
    override val image: Image =
      zio.aws.iotanalytics.model.primitives.Image(impl.image())
    override val executionRoleArn: RoleArn =
      zio.aws.iotanalytics.model.primitives.RoleArn(impl.executionRoleArn())
    override val resourceConfiguration
        : zio.aws.iotanalytics.model.ResourceConfiguration.ReadOnly =
      zio.aws.iotanalytics.model.ResourceConfiguration
        .wrap(impl.resourceConfiguration())
    override val variables
        : Option[List[zio.aws.iotanalytics.model.Variable.ReadOnly]] = scala
      .Option(impl.variables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.Variable.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.ContainerDatasetAction
  ): zio.aws.iotanalytics.model.ContainerDatasetAction.ReadOnly = new Wrapper(
    impl
  )
}
