package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.iotanalytics.model.primitives.{
  Timestamp,
  ChannelArn,
  ChannelName
}
import scala.jdk.CollectionConverters._
final case class Channel(
    name: Option[ChannelName] = None,
    storage: Option[zio.aws.iotanalytics.model.ChannelStorage] = None,
    arn: Option[ChannelArn] = None,
    status: Option[zio.aws.iotanalytics.model.ChannelStatus] = None,
    retentionPeriod: Option[zio.aws.iotanalytics.model.RetentionPeriod] = None,
    creationTime: Option[Timestamp] = None,
    lastUpdateTime: Option[Timestamp] = None,
    lastMessageArrivalTime: Option[Timestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Channel = {
    import Channel.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Channel
      .builder()
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(storage.map(value => value.buildAwsValue()))(_.storage)
      .optionallyWith(
        arn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(retentionPeriod.map(value => value.buildAwsValue()))(
        _.retentionPeriod
      )
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .optionallyWith(
        lastMessageArrivalTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastMessageArrivalTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Channel.ReadOnly =
    zio.aws.iotanalytics.model.Channel.wrap(buildAwsValue())
}
object Channel {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Channel
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Channel =
      zio.aws.iotanalytics.model.Channel(
        name.map(value => value),
        storage.map(value => value.asEditable),
        arn.map(value => value),
        status.map(value => value),
        retentionPeriod.map(value => value.asEditable),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value),
        lastMessageArrivalTime.map(value => value)
      )
    def name: Option[ChannelName]
    def storage: Option[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly]
    def arn: Option[ChannelArn]
    def status: Option[zio.aws.iotanalytics.model.ChannelStatus]
    def retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly]
    def creationTime: Option[Timestamp]
    def lastUpdateTime: Option[Timestamp]
    def lastMessageArrivalTime: Option[Timestamp]
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getStorage: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ChannelStorage.ReadOnly
    ] = AwsError.unwrapOptionField("storage", storage)
    def getArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.ChannelStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRetentionPeriod: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly
    ] = AwsError.unwrapOptionField("retentionPeriod", retentionPeriod)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
    def getLastMessageArrivalTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastMessageArrivalTime", lastMessageArrivalTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Channel
  ) extends zio.aws.iotanalytics.model.Channel.ReadOnly {
    override val name: Option[ChannelName] = scala
      .Option(impl.name())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelName(value))
    override val storage
        : Option[zio.aws.iotanalytics.model.ChannelStorage.ReadOnly] = scala
      .Option(impl.storage())
      .map(value => zio.aws.iotanalytics.model.ChannelStorage.wrap(value))
    override val arn: Option[ChannelArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.iotanalytics.model.primitives.ChannelArn(value))
    override val status: Option[zio.aws.iotanalytics.model.ChannelStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.iotanalytics.model.ChannelStatus.wrap(value))
    override val retentionPeriod
        : Option[zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly] = scala
      .Option(impl.retentionPeriod())
      .map(value => zio.aws.iotanalytics.model.RetentionPeriod.wrap(value))
    override val creationTime: Option[Timestamp] = scala
      .Option(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Option[Timestamp] = scala
      .Option(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastMessageArrivalTime: Option[Timestamp] = scala
      .Option(impl.lastMessageArrivalTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Channel
  ): zio.aws.iotanalytics.model.Channel.ReadOnly = new Wrapper(impl)
}
