package zio.aws.iotanalytics.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{
  RetentionPeriodInDays,
  UnlimitedRetentionPeriod
}
import scala.jdk.CollectionConverters._
final case class RetentionPeriod(
    unlimited: Option[UnlimitedRetentionPeriod] = None,
    numberOfDays: Option[RetentionPeriodInDays] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod = {
    import RetentionPeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
      .builder()
      .optionallyWith(
        unlimited.map(value =>
          UnlimitedRetentionPeriod.unwrap(value): java.lang.Boolean
        )
      )(_.unlimited)
      .optionallyWith(
        numberOfDays.map(value => RetentionPeriodInDays.unwrap(value): Integer)
      )(_.numberOfDays)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly =
    zio.aws.iotanalytics.model.RetentionPeriod.wrap(buildAwsValue())
}
object RetentionPeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.RetentionPeriod =
      zio.aws.iotanalytics.model.RetentionPeriod(
        unlimited.map(value => value),
        numberOfDays.map(value => value)
      )
    def unlimited: Option[UnlimitedRetentionPeriod]
    def numberOfDays: Option[RetentionPeriodInDays]
    def getUnlimited: ZIO[Any, AwsError, UnlimitedRetentionPeriod] =
      AwsError.unwrapOptionField("unlimited", unlimited)
    def getNumberOfDays: ZIO[Any, AwsError, RetentionPeriodInDays] =
      AwsError.unwrapOptionField("numberOfDays", numberOfDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
  ) extends zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly {
    override val unlimited: Option[UnlimitedRetentionPeriod] = scala
      .Option(impl.unlimited())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.UnlimitedRetentionPeriod(value)
      )
    override val numberOfDays: Option[RetentionPeriodInDays] = scala
      .Option(impl.numberOfDays())
      .map(value =>
        zio.aws.iotanalytics.model.primitives.RetentionPeriodInDays(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
  ): zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly = new Wrapper(impl)
}
