package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iotanalytics.model.primitives.{AttributeName, ActivityName}
import scala.jdk.CollectionConverters._
final case class RemoveAttributesActivity(
    name: ActivityName,
    attributes: Iterable[AttributeName],
    next: Option[ActivityName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.RemoveAttributesActivity = {
    import RemoveAttributesActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.RemoveAttributesActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .attributes(attributes.map { item =>
        AttributeName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly =
    zio.aws.iotanalytics.model.RemoveAttributesActivity.wrap(buildAwsValue())
}
object RemoveAttributesActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.RemoveAttributesActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.RemoveAttributesActivity =
      zio.aws.iotanalytics.model
        .RemoveAttributesActivity(name, attributes, next.map(value => value))
    def name: ActivityName
    def attributes: List[AttributeName]
    def next: Option[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getAttributes: ZIO[Any, Nothing, List[AttributeName]] =
      ZIO.succeed(attributes)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.RemoveAttributesActivity
  ) extends zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val attributes: List[AttributeName] = impl
      .attributes()
      .asScala
      .map { item =>
        zio.aws.iotanalytics.model.primitives.AttributeName(item)
      }
      .toList
    override val next: Option[ActivityName] = scala
      .Option(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.RemoveAttributesActivity
  ): zio.aws.iotanalytics.model.RemoveAttributesActivity.ReadOnly = new Wrapper(
    impl
  )
}
