package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FileFormatConfiguration(
    jsonConfiguration: Option[zio.aws.iotanalytics.model.JsonConfiguration] =
      None,
    parquetConfiguration: Option[
      zio.aws.iotanalytics.model.ParquetConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.FileFormatConfiguration = {
    import FileFormatConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.FileFormatConfiguration
      .builder()
      .optionallyWith(jsonConfiguration.map(value => value.buildAwsValue()))(
        _.jsonConfiguration
      )
      .optionallyWith(parquetConfiguration.map(value => value.buildAwsValue()))(
        _.parquetConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly =
    zio.aws.iotanalytics.model.FileFormatConfiguration.wrap(buildAwsValue())
}
object FileFormatConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.FileFormatConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.FileFormatConfiguration =
      zio.aws.iotanalytics.model.FileFormatConfiguration(
        jsonConfiguration.map(value => value.asEditable),
        parquetConfiguration.map(value => value.asEditable)
      )
    def jsonConfiguration
        : Option[zio.aws.iotanalytics.model.JsonConfiguration.ReadOnly]
    def parquetConfiguration
        : Option[zio.aws.iotanalytics.model.ParquetConfiguration.ReadOnly]
    def getJsonConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.JsonConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("jsonConfiguration", jsonConfiguration)
    def getParquetConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iotanalytics.model.ParquetConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("parquetConfiguration", parquetConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.FileFormatConfiguration
  ) extends zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly {
    override val jsonConfiguration
        : Option[zio.aws.iotanalytics.model.JsonConfiguration.ReadOnly] = scala
      .Option(impl.jsonConfiguration())
      .map(value => zio.aws.iotanalytics.model.JsonConfiguration.wrap(value))
    override val parquetConfiguration
        : Option[zio.aws.iotanalytics.model.ParquetConfiguration.ReadOnly] =
      scala
        .Option(impl.parquetConfiguration())
        .map(value =>
          zio.aws.iotanalytics.model.ParquetConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.FileFormatConfiguration
  ): zio.aws.iotanalytics.model.FileFormatConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
