package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.iotanalytics.model.primitives.{ColumnDataType, ColumnName}
import scala.jdk.CollectionConverters._
final case class Column(name: ColumnName, `type`: ColumnDataType) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.Column = {
    import Column.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.Column
      .builder()
      .name(ColumnName.unwrap(name): java.lang.String)
      .`type`(ColumnDataType.unwrap(`type`): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.Column.ReadOnly =
    zio.aws.iotanalytics.model.Column.wrap(buildAwsValue())
}
object Column {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.Column
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.Column =
      zio.aws.iotanalytics.model.Column(name, `type`)
    def name: ColumnName
    def `type`: ColumnDataType
    def getName: ZIO[Any, Nothing, ColumnName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, ColumnDataType] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.Column
  ) extends zio.aws.iotanalytics.model.Column.ReadOnly {
    override val name: ColumnName =
      zio.aws.iotanalytics.model.primitives.ColumnName(impl.name())
    override val `type`: ColumnDataType =
      zio.aws.iotanalytics.model.primitives.ColumnDataType(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.Column
  ): zio.aws.iotanalytics.model.Column.ReadOnly = new Wrapper(impl)
}
