package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{
  RetentionPeriodInDays,
  UnlimitedRetentionPeriod
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RetentionPeriod(
    unlimited: Optional[UnlimitedRetentionPeriod] = Optional.Absent,
    numberOfDays: Optional[RetentionPeriodInDays] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod = {
    import RetentionPeriod.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
      .builder()
      .optionallyWith(
        unlimited.map(value =>
          UnlimitedRetentionPeriod.unwrap(value): java.lang.Boolean
        )
      )(_.unlimited)
      .optionallyWith(
        numberOfDays.map(value => RetentionPeriodInDays.unwrap(value): Integer)
      )(_.numberOfDays)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly =
    zio.aws.iotanalytics.model.RetentionPeriod.wrap(buildAwsValue())
}
object RetentionPeriod {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.RetentionPeriod =
      zio.aws.iotanalytics.model.RetentionPeriod(
        unlimited.map(value => value),
        numberOfDays.map(value => value)
      )
    def unlimited: Optional[UnlimitedRetentionPeriod]
    def numberOfDays: Optional[RetentionPeriodInDays]
    def getUnlimited: ZIO[Any, AwsError, UnlimitedRetentionPeriod] =
      AwsError.unwrapOptionField("unlimited", unlimited)
    def getNumberOfDays: ZIO[Any, AwsError, RetentionPeriodInDays] =
      AwsError.unwrapOptionField("numberOfDays", numberOfDays)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
  ) extends zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly {
    override val unlimited: Optional[UnlimitedRetentionPeriod] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unlimited())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.UnlimitedRetentionPeriod(value)
        )
    override val numberOfDays: Optional[RetentionPeriodInDays] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfDays())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.RetentionPeriodInDays(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.RetentionPeriod
  ): zio.aws.iotanalytics.model.RetentionPeriod.ReadOnly = new Wrapper(impl)
}
