package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.DatasetContentVersion
import scala.jdk.CollectionConverters._
final case class CreateDatasetContentResponse(
    versionId: Optional[DatasetContentVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse = {
    import CreateDatasetContentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse
      .builder()
      .optionallyWith(
        versionId.map(value =>
          DatasetContentVersion.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .build()
  }
  def asReadOnly
      : zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly =
    zio.aws.iotanalytics.model.CreateDatasetContentResponse
      .wrap(buildAwsValue())
}
object CreateDatasetContentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.CreateDatasetContentResponse =
      zio.aws.iotanalytics.model
        .CreateDatasetContentResponse(versionId.map(value => value))
    def versionId: Optional[DatasetContentVersion]
    def getVersionId: ZIO[Any, AwsError, DatasetContentVersion] =
      AwsError.unwrapOptionField("versionId", versionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse
  ) extends zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly {
    override val versionId: Optional[DatasetContentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionId())
        .map(value =>
          zio.aws.iotanalytics.model.primitives.DatasetContentVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.CreateDatasetContentResponse
  ): zio.aws.iotanalytics.model.CreateDatasetContentResponse.ReadOnly =
    new Wrapper(impl)
}
