package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.{AttributeName, ActivityName}
import scala.jdk.CollectionConverters._
final case class AddAttributesActivity(
    name: ActivityName,
    attributes: Map[AttributeName, AttributeName],
    next: Optional[ActivityName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.AddAttributesActivity = {
    import AddAttributesActivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.AddAttributesActivity
      .builder()
      .name(ActivityName.unwrap(name): java.lang.String)
      .attributes(
        attributes
          .map({ case (key, value) =>
            (AttributeName.unwrap(key): java.lang.String) -> (AttributeName
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        next.map(value => ActivityName.unwrap(value): java.lang.String)
      )(_.next)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly =
    zio.aws.iotanalytics.model.AddAttributesActivity.wrap(buildAwsValue())
}
object AddAttributesActivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.AddAttributesActivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.AddAttributesActivity =
      zio.aws.iotanalytics.model
        .AddAttributesActivity(name, attributes, next.map(value => value))
    def name: ActivityName
    def attributes: Map[AttributeName, AttributeName]
    def next: Optional[ActivityName]
    def getName: ZIO[Any, Nothing, ActivityName] = ZIO.succeed(name)
    def getAttributes: ZIO[Any, Nothing, Map[AttributeName, AttributeName]] =
      ZIO.succeed(attributes)
    def getNext: ZIO[Any, AwsError, ActivityName] =
      AwsError.unwrapOptionField("next", next)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.AddAttributesActivity
  ) extends zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly {
    override val name: ActivityName =
      zio.aws.iotanalytics.model.primitives.ActivityName(impl.name())
    override val attributes: Map[AttributeName, AttributeName] = impl
      .attributes()
      .asScala
      .map({ case (key, value) =>
        zio.aws.iotanalytics.model.primitives.AttributeName(
          key
        ) -> zio.aws.iotanalytics.model.primitives.AttributeName(value)
      })
      .toMap
    override val next: Optional[ActivityName] = zio.aws.core.internal
      .optionalFromNullable(impl.next())
      .map(value => zio.aws.iotanalytics.model.primitives.ActivityName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.AddAttributesActivity
  ): zio.aws.iotanalytics.model.AddAttributesActivity.ReadOnly = new Wrapper(
    impl
  )
}
