package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class QueryFilter(
    deltaTime: Optional[zio.aws.iotanalytics.model.DeltaTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.QueryFilter = {
    import QueryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.QueryFilter
      .builder()
      .optionallyWith(deltaTime.map(value => value.buildAwsValue()))(
        _.deltaTime
      )
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.QueryFilter.ReadOnly =
    zio.aws.iotanalytics.model.QueryFilter.wrap(buildAwsValue())
}
object QueryFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.QueryFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.QueryFilter =
      zio.aws.iotanalytics.model
        .QueryFilter(deltaTime.map(value => value.asEditable))
    def deltaTime: Optional[zio.aws.iotanalytics.model.DeltaTime.ReadOnly]
    def getDeltaTime
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DeltaTime.ReadOnly] =
      AwsError.unwrapOptionField("deltaTime", deltaTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.QueryFilter
  ) extends zio.aws.iotanalytics.model.QueryFilter.ReadOnly {
    override val deltaTime
        : Optional[zio.aws.iotanalytics.model.DeltaTime.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deltaTime())
        .map(value => zio.aws.iotanalytics.model.DeltaTime.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.QueryFilter
  ): zio.aws.iotanalytics.model.QueryFilter.ReadOnly = new Wrapper(impl)
}
