package zio.aws.iotanalytics.model
import zio.aws.iotanalytics.model.primitives.{Timestamp, PipelineName}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PipelineSummary(
    pipelineName: Optional[PipelineName] = Optional.Absent,
    reprocessingSummaries: Optional[
      Iterable[zio.aws.iotanalytics.model.ReprocessingSummary]
    ] = Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdateTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.PipelineSummary = {
    import PipelineSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.PipelineSummary
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        reprocessingSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reprocessingSummaries)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdateTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdateTime)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.PipelineSummary.ReadOnly =
    zio.aws.iotanalytics.model.PipelineSummary.wrap(buildAwsValue())
}
object PipelineSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.PipelineSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.PipelineSummary =
      zio.aws.iotanalytics.model.PipelineSummary(
        pipelineName.map(value => value),
        reprocessingSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastUpdateTime.map(value => value)
      )
    def pipelineName: Optional[PipelineName]
    def reprocessingSummaries: Optional[
      List[zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly]
    ]
    def creationTime: Optional[Timestamp]
    def lastUpdateTime: Optional[Timestamp]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getReprocessingSummaries: ZIO[Any, AwsError, List[
      zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly
    ]] =
      AwsError.unwrapOptionField("reprocessingSummaries", reprocessingSummaries)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdateTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdateTime", lastUpdateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.PipelineSummary
  ) extends zio.aws.iotanalytics.model.PipelineSummary.ReadOnly {
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.iotanalytics.model.primitives.PipelineName(value))
    override val reprocessingSummaries: Optional[
      List[zio.aws.iotanalytics.model.ReprocessingSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.reprocessingSummaries())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.iotanalytics.model.ReprocessingSummary.wrap(item)
        }.toList
      )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
    override val lastUpdateTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdateTime())
      .map(value => zio.aws.iotanalytics.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.PipelineSummary
  ): zio.aws.iotanalytics.model.PipelineSummary.ReadOnly = new Wrapper(impl)
}
