package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.iotanalytics.model.primitives.Reason
import scala.jdk.CollectionConverters._
final case class DatasetContentStatus(
    state: Optional[zio.aws.iotanalytics.model.DatasetContentState] =
      Optional.Absent,
    reason: Optional[Reason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus = {
    import DatasetContentStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus
      .builder()
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        reason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly =
    zio.aws.iotanalytics.model.DatasetContentStatus.wrap(buildAwsValue())
}
object DatasetContentStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DatasetContentStatus =
      zio.aws.iotanalytics.model.DatasetContentStatus(
        state.map(value => value),
        reason.map(value => value)
      )
    def state: Optional[zio.aws.iotanalytics.model.DatasetContentState]
    def reason: Optional[Reason]
    def getState
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.DatasetContentState] =
      AwsError.unwrapOptionField("state", state)
    def getReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus
  ) extends zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly {
    override val state
        : Optional[zio.aws.iotanalytics.model.DatasetContentState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.iotanalytics.model.DatasetContentState.wrap(value)
        )
    override val reason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.iotanalytics.model.primitives.Reason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DatasetContentStatus
  ): zio.aws.iotanalytics.model.DatasetContentStatus.ReadOnly = new Wrapper(
    impl
  )
}
