package zio.aws.iotanalytics.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePipelineResponse(
    pipeline: Optional[zio.aws.iotanalytics.model.Pipeline] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse = {
    import DescribePipelineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly: zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly =
    zio.aws.iotanalytics.model.DescribePipelineResponse.wrap(buildAwsValue())
}
object DescribePipelineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iotanalytics.model.DescribePipelineResponse =
      zio.aws.iotanalytics.model
        .DescribePipelineResponse(pipeline.map(value => value.asEditable))
    def pipeline: Optional[zio.aws.iotanalytics.model.Pipeline.ReadOnly]
    def getPipeline
        : ZIO[Any, AwsError, zio.aws.iotanalytics.model.Pipeline.ReadOnly] =
      AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse
  ) extends zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly {
    override val pipeline
        : Optional[zio.aws.iotanalytics.model.Pipeline.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipeline())
        .map(value => zio.aws.iotanalytics.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iotanalytics.model.DescribePipelineResponse
  ): zio.aws.iotanalytics.model.DescribePipelineResponse.ReadOnly = new Wrapper(
    impl
  )
}
